precision highp float;

uniform sampler2D S;

/*
	Applies following effects:
		Vignette
		Blur in X shape to get glow effect
		Chromatic aberration
*/

void main() {

	// Calculate screen position and vignette strength
	vec2 p = gl_FragCoord.xy;
	float dist, vignette = length((p-vec2(1280,720)*.5)/720.);
	vignette *= vignette;
	p/=vec2(1280,720);
	
	// Apply blur
	vec4 val, sum = vec4(0);
	for (int i=-9; i<10; i++) {
		val = texture2D(S, p - vec2(1) * float(i) * .0025);
		dist = 1. - (abs(float(i)) * .1);
		sum += val * dist * dist * dot(val,val) * .0132;
	}
	for (int i=-9; i<10; i++) {
		val = texture2D(S, p - vec2(-1,1) * float(i) * .0025);
		dist = 1. - (abs(float(i)) * .1);
		sum += val * dist * dist * dot(val,val) * .0132;
	}
	
	// Apply chromatic aberration
	sum += vec4(texture2D(S, p-vec2(.01,.0)*vignette).x,
				texture2D(S, p-vec2(.0,.01)*vignette).y,
				texture2D(S, p).z,
				0);

	// Apply vignette
	sum *=(1.-vignette);
	sum.w = 1.;
	gl_FragColor = sum;
}