/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements. The ASF licenses this
file to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.   
*/

#include "BerconMetaballTex.h"

#define BerconMetaballTex_CLASS_ID	Class_ID(0x8b0db489, 0x640949c4)

#define NSUBTEX		0
#define COORD_REF	0

#define PBLOCK_REF	0

class BerconMetaballTex;

class BerconMetaballTex : public Tex3D {
	public:

		// Parameter block
		IParamBlock2	*pblock;	//ref 0

		//Texmap			*subtex[NSUBTEX];
		Interval		ivalid;

		//From MtlBase
		ParamDlg* CreateParamDlg(HWND hwMtlEdit, IMtlParams *imp);
		BOOL SetDlgThing(ParamDlg* dlg);
		void Update(TimeValue t, Interval& valid);
		void Reset();
		Interval Validity(TimeValue t);
		ULONG LocalRequirements(int subMtlNum);

		int NumSubTexmaps() { return NSUBTEX; }
		Texmap* GetSubTexmap(int i) { return NULL; }
		void SetSubTexmap(int i, Texmap *m);
		TSTR GetSubTexmapSlotName(int i);
		
		//From Texmap
		RGBA EvalColor(ShadeContext& sc);
		float EvalMono(ShadeContext& sc);
		Point3 EvalNormalPerturb(ShadeContext& sc);

		XYZGen *GetTheXYZGen() { return NULL; } 
		
		int SubNumToRefNum(int subNum) { return subNum; }
		
		void ReadSXPData(TCHAR *name, void *sxpdata) { }
		
		//From Animatable
		Class_ID ClassID() {return BerconMetaballTex_CLASS_ID;}		
		SClass_ID SuperClassID() { return TEXMAP_CLASS_ID; }
		void GetClassName(TSTR& s) {s = GetString(IDS_CLASS_NAME);}

		RefTargetHandle Clone( RemapDir &remap );
		RefResult NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, 
			PartID& partID,  RefMessage message);

		int NumSubs() { return 1+NSUBTEX; }
		Animatable* SubAnim(int i); 
		TSTR SubAnimName(int i);

		// TODO: Maintain the number or references here 
		int NumRefs() { return 1+NSUBTEX; }
		RefTargetHandle GetReference(int i);
		void SetReference(int i, RefTargetHandle rtarg);

		int	NumParamBlocks() { return 1; }					// return number of ParamBlocks in this instance
		IParamBlock2* GetParamBlock(int i) { return pblock; } // return i'th ParamBlock
		IParamBlock2* GetParamBlockByID(BlockID id) { return (pblock->ID() == id) ? pblock : NULL; } // return id'd ParamBlock

		void DeleteThis() { delete this; }		
		
		//Constructor/Destructor
		BerconMetaballTex();
		~BerconMetaballTex();		

};

class BerconMetaballTexClassDesc : public ClassDesc2 
{
public:
	virtual int IsPublic() 							{ return TRUE; }
	virtual void* Create(BOOL /*loading = FALSE*/) 	{ return new BerconMetaballTex(); }
	virtual const TCHAR *	ClassName() 			{ return GetString(IDS_CLASS_NAME); }
	virtual SClass_ID SuperClassID() 				{ return TEXMAP_CLASS_ID; }
	virtual Class_ID ClassID() 						{ return BerconMetaballTex_CLASS_ID; }
	virtual const TCHAR* Category() 				{ return GetString(IDS_CATEGORY); }

	virtual const TCHAR* InternalName() 			{ return _T("BerconMetaballTex"); }	// returns fixed parsable name (scripter-visible name)
	virtual HINSTANCE HInstance() 					{ return hInstance; }					// returns owning module handle	
};

static BerconMetaballTexClassDesc BerconMetaballTexDesc;
ClassDesc2* GetBerconMetaballTexDesc() { return &BerconMetaballTexDesc; }

enum { berconmetaballtex_params };

//TODO: Add enums for various parameters
enum { 
};

static ParamBlockDesc2 berconmetaballtex_param_blk ( berconmetaballtex_params, _T("params"),  0, &BerconMetaballTexDesc, 
	P_AUTO_CONSTRUCT + P_AUTO_UI, PBLOCK_REF, 
	//rollout
	IDD_PANEL, IDS_PARAMS, 0, 0, NULL,
	// params
	end
);

//ParamDlg* BerconMetaballTex::xyzGenDlg;

//--- BerconMetaballTex -------------------------------------------------------
BerconMetaballTex::BerconMetaballTex() {
	pblock = NULL;
	BerconMetaballTexDesc.MakeAutoParamBlocks(this);
	Reset();
}

BerconMetaballTex::~BerconMetaballTex() {
}

//From MtlBase
void BerconMetaballTex::Reset() {
	ivalid.SetEmpty();
}

void BerconMetaballTex::Update(TimeValue t, Interval& valid) {		
}

Interval BerconMetaballTex::Validity(TimeValue t) {
	return ivalid;
}

ParamDlg* BerconMetaballTex::CreateParamDlg(HWND hwMtlEdit, IMtlParams *imp)  {
	IAutoMParamDlg* masterDlg = BerconMetaballTexDesc.CreateParamDlgs(hwMtlEdit, imp, this);
	return masterDlg;	
}

BOOL BerconMetaballTex::SetDlgThing(ParamDlg* dlg) {	
	return FALSE;
}

void BerconMetaballTex::SetSubTexmap(int i, Texmap *m) {
}

TSTR BerconMetaballTex::GetSubTexmapSlotName(int i) {	
	return TSTR(_T(""));
}

//From ReferenceMaker
RefTargetHandle BerconMetaballTex::GetReference(int i)  {
	switch (i) {
		case 0: return pblock;
		default: return NULL;
	}	
}

void BerconMetaballTex::SetReference(int i, RefTargetHandle rtarg)  {
	switch(i) {
		case 0:	pblock = (IParamBlock2 *)rtarg; break;
	}
}

//From ReferenceTarget 
RefTargetHandle BerconMetaballTex::Clone(RemapDir &remap) {
	BerconMetaballTex *mnew = new BerconMetaballTex();
	*((MtlBase*)mnew) = *((MtlBase*)this); // copy superclass stuff	
	BaseClone(this, mnew, remap);
	return (RefTargetHandle)mnew;
}
	 
Animatable* BerconMetaballTex::SubAnim(int i)  {
	switch (i) {
		case 0: return pblock;
		default: return NULL;
	}
}

TSTR BerconMetaballTex::SubAnimName(int i)  {
	switch (i) {
		case 1: return GetString(IDS_PARAMS);
		default: return GetSubTexmapTVName(i-1);
	}
}

RefResult BerconMetaballTex::NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, PartID& partID, RefMessage message ) {
	return(REF_SUCCEED);
}

AColor BerconMetaballTex::EvalColor(ShadeContext& sc) {
	// Initialize returned color
	AColor res(0.0f,0.0f,0.0f,0.0f);
	if (!sc.doMaps) return res;

	// Use cache
	if (sc.GetCache(this,res)) 
		return res; 	
	if (gbufID) sc.SetGBufferID(gbufID);		
	
	Point3 bary = sc.BarycentricCoords();
	return AColor(bary.x, bary.y, bary.z, 1.f);
}

float BerconMetaballTex::EvalMono(ShadeContext& sc) {
	return Intens(EvalColor(sc));
}

Point3 BerconMetaballTex::EvalNormalPerturb(ShadeContext& sc) {
	return Point3(0, 0, 0);
}

ULONG BerconMetaballTex::LocalRequirements(int subMtlNum) {
	return 0; 
}