/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements. The ASF licenses this
file to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.   
*/

#pragma once

//#include "vraybase.h"

//using namespace VR;

/*
	The field kernel functions

	Note: size and radius are both squared, taking root is very slow process so we avoid it
*/

// (1. - x^2)^2
inline double fieldFunctionPower2(double size, double radius) {
	double temp = (1. - radius / size);
	return temp * temp;
}

// (1. - x^2)^3
inline double fieldFunctionPower3(double size, double radius) {
	double temp = (1. - radius / size);
	return temp * temp * temp;
}

// (1. - x^2)^4
inline double fieldFunctionPower4(double size, double radius) {
	double temp = (1. - radius / size);
	temp *= temp;
	return temp * temp ;
}

// (1. - x^2)^5
inline double fieldFunctionPower5(double size, double radius) {
	double temp = (1. - radius / size);
	double temp2 = temp * temp;
	temp2 *= temp2;
	return temp * temp2;
}

// (1-x^2)^2*(3-2*(1-x^2))
// 2*x^6-3*x^4+1
inline double fieldFunctionHermit2(double size, double radius) {
	double temp = (1. - radius / size);
	return temp * temp * (3. - 2. * temp);
}

// (1-x^2)^4*(3-2*(1-x^2))
inline double fieldFunctionHermit4(double size, double radius) {
	double temp = (1. - radius / size);
	double temp2 = temp * temp;
	temp2 *= temp2;
	return temp2 * (3. - 2. * temp);
}


// 1.+(17. x^4)/9.-(4. x^6)/9.-(22. x^2)/9.
// 1+17/9*x^4-4/9*x^6-22/9*x^2
// 1+(17*x^4-4*x^6-22*x^2)/9
inline double fieldFunctionWyvill(double size, double radius) {
	double temp = radius / size;	
	double temp2 = temp * temp; 		
	return 1. + 17. / 9. * temp2 - 4.0 / 9. * temp2 * temp - 22. / 9. * temp;	
}