/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements. The ASF licenses this
file to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.   
*/

#include "field.h"

using namespace VR;

/*
	Normal
*/

// Static

void Field::addPoints(int* points, int count) {
	Ireal r;
	if (radii)
		for (int i=0;i<count;i++) {			
			r = (pointCloud[points[i]]-location).lengthSqr();
			if (r > radii[points[i]]) continue;
			res += function(radii[points[i]], r);
		}
	else
		for (int i=0;i<count;i++) {
			r = (pointCloud[points[i]]-location).lengthSqr();
			if (r > size2) continue;
			res += function(size2, r);
		}
}

void FieldColor::addPoints(int* points, int count) {
	Ireal r;
	Ireal w;
	if (radii)
		for (int i=0;i<count;i++) {			
			r = (pointCloud[points[i]]-location).lengthSqr();
			if (r > radii[points[i]]) continue;
			w = function(radii[points[i]], r);
			res += w;
			col += colors[points[i]] * w;
		}
	else
		for (int i=0;i<count;i++) {
			r = (pointCloud[points[i]]-location).lengthSqr();
			if (r > size2) continue;
			w = function(size2, r);
			res += w;
			col += colors[points[i]] * w;
		}
}

void FieldGrad::addPoints(int* points, int count) {
	Ireal r;
	if (radii)
		for (int i=0;i<count;i++) {			
			for (int j=0;j<4;j++) {
				r = (pointCloud[points[i]]-location[j]).lengthSqr();
				if (r > radii[points[i]]) continue;
				res[j] += function(radii[points[i]], r);
			}
		}
	else
		for (int i=0;i<count;i++) {			
			for (int j=0;j<4;j++) {
				r = (pointCloud[points[i]]-location[j]).lengthSqr();
				if (r > size2) continue;
				res[j] += function(size2, r);
			}
		}	
}

// Moving

void FieldMoving::addPoints(Vector* cloud, int count) {
	Ireal r;
	for (int i=0;i<count;i++) {
		r = (cloud[i]-location).lengthSqr();
		if (r > size2) continue;
		res += function(size2, r);
	}
}

void FieldMoving::addPoints(Vector* cloud, Ireal* sizes, VR::Ireal* sizesLin, int count) {
	Ireal r;
	for (int i=0;i<count;i++) {
		r = (cloud[i]-location).lengthSqr();
		if (r > sizes[i]) continue;
		res += function(sizes[i], r);
	}
}

void FieldGradMoving::addPoints(Vector* cloud, int* points, int count) {
	Ireal r;
	for (int i=0;i<count;i++) {			
		for (int j=0;j<4;j++) {
			r = (cloud[i]-location[j]).lengthSqr();
			if (r > size2) continue;
			res[j] += function(size2, r);
			if (j == 0 && colors) {
				Ireal w = function2(size2, r);
				colr += w;
				col += colors[points[i]] * w;
			}
		}
	}
}

void FieldGradMoving::addPoints(Vector* cloud, Ireal* sizes, VR::Ireal* sizesLin, int* points, int count) {
	Ireal r;
	for (int i=0;i<count;i++) {			
		for (int j=0;j<4;j++) {
			r = (cloud[i]-location[j]).lengthSqr();
			if (r > sizes[i]) continue;
			res[j] += function(sizes[i], r);
			if (j == 0 && colors) {
				Ireal w = function2(sizes[i], r);
				colr += w;
				col += colors[points[i]] * w;
			}
		}
	}
}

/*
	Average
*/

// Static

void FieldAvg::addPoints(int* points, int count) {
	Ireal r;
	Ireal w;
	
	if (radii)
		for (int i=0;i<count;i++) {			
			r = (pointCloud[points[i]]-location).lengthSqr();
			Ireal squared = radii[points[i]] * radii[points[i]];
			if (r > squared) continue;
			w = function(squared, r);
			totalP += pointCloud[points[i]] * w;
			totalW += w;				
			totalR += radii[points[i]] * w;
		}
	else
		for (int i=0;i<count;i++) {			
			r = (pointCloud[points[i]]-location).lengthSqr();
			if (r > size2) continue;
			w = function(size2, r);
			totalP += pointCloud[points[i]] * w;
			totalW += w;				
		}
}
   
void FieldGradAvg::addPoints(int* points, int count) {
	Ireal r;
	Ireal w;
	if (radii)		
		for (int i=0;i<count;i++) {			
			for (int j=0;j<4;j++) {
				r = (pointCloud[points[i]]-location[j]).lengthSqr();
				Ireal squared = radii[points[i]] * radii[points[i]];
				if (r > squared) continue;
				w = function(squared, r);
				totalP[j] += pointCloud[points[i]] * w;
				totalW[j] += w;			
				totalR[j] += radii[points[i]] * w;
			}
		}
	else
		for (int i=0;i<count;i++) {			
			for (int j=0;j<4;j++) {
				r = (pointCloud[points[i]]-location[j]).lengthSqr();
				if (r > size2) continue;
				w = function(size2, r);
				totalP[j] += pointCloud[points[i]] * w;
				totalW[j] += w;			
			}
		}
}

// Moving

void FieldMovingAvg::addPoints(Vector* cloud, int count) {
	Ireal r;
	Ireal w;
	for (int i=0;i<count;i++) {			
		r = (cloud[i]-location).lengthSqr();
		if (r > size2) continue;
		w = function(size2, r);
		totalP += cloud[i] * w;
		totalW += w;				
	}
}

void FieldMovingAvg::addPoints(Vector* cloud, Ireal* sizes, Ireal* sizesLin, int count) {
	Ireal r;
	Ireal w;
	for (int i=0;i<count;i++) {			
		r = (cloud[i]-location).lengthSqr();
		if (r > sizes[i]) continue;
		w = function(sizes[i], r);
		totalP += cloud[i] * w;
		totalW += w;				
		totalR += sizesLin[i] * w;
	}
}

void FieldGradMovingAvg::addPoints(Vector* cloud, int* points, int count) {
	Ireal r;
	Ireal w;
	for (int i=0;i<count;i++) {			
		for (int j=0;j<4;j++) {
			r = (cloud[i]-location[j]).lengthSqr();
			if (r > size2) continue;
			w = function(size2, r);
			totalP[j] += cloud[i] * w;
			totalW[j] += w;			
			if (j == 0 && colors) {
				w = function2(size2, r);
				colr += w;
				col += colors[points[i]] * w;
			}
		}
	}
}

void FieldGradMovingAvg::addPoints(Vector* cloud, Ireal* sizes, Ireal* sizesLin, int* points, int count) {
	Ireal r;
	Ireal w;
	for (int i=0;i<count;i++) {			
		for (int j=1;j<4;j++) {
			r = (cloud[i]-location[j]).lengthSqr();
			if (r > sizes[i]) continue;
			w = function(sizes[i], r);
			totalP[j] += cloud[i] * w;
			totalW[j] += w;			
			totalR[j] += sizesLin[i] * w;
			if (j == 0 && colors) {
				w = function2(sizes[i], r);
				colr += w;
				col += colors[points[i]] * w;
			}
		}
	}
}