/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements. The ASF licenses this
file to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.   
*/

#pragma once

#include "max.h"
#include "iparamb2.h"

#define NOT_USED_VECTOR (Point3(0.f,0.f,1.f))

class BerconShadeContext : public ShadeContext {
private:
	Point3 worldPos;
	//Point3 localPos;	
	//Matrix3 tm;
	//Matrix3 itm;

public:
	BerconShadeContext();
	//BerconShadeContext(Matrix3 tm, Matrix3 itm);
	void Init(Point3 worldPos);

	BOOL InMtlEditor()						{ return FALSE; }
	LightDesc* Light(int n)					{ return NULL; }
	TimeValue CurTime()						{ return 0; } // TODO: I doubt anything really uses this param
	INode *Node()							{ return NULL; }
	int FaceNumber()						{ return 0; }
	Point3 Normal()							{ return NOT_USED_VECTOR; }
	Point3 GNormal()						{ return NOT_USED_VECTOR; }
	Point3 V()								{ return NOT_USED_VECTOR; }
	void SetView(Point3 p)					{ ; }
	Point3 ReflectVector()					{ return NOT_USED_VECTOR; }
	Point3 RefractVector(float ior)			{ return NOT_USED_VECTOR; }
	Point3 CamPos()							{ return NOT_USED_VECTOR; }
	
	Point3 P()								{ return worldPos; }
	Point3 DP()								{ return NOT_USED_VECTOR; }
	Point3 PObj()							{ return worldPos; }
	Point3 DPObj()							{ return NOT_USED_VECTOR; }
	Box3 ObjectBox()						{ return Box3(); }
	Point3 PObjRelBox()		  				{ return NOT_USED_VECTOR; }
	Point3 DPObjRelBox()					{ return NOT_USED_VECTOR; }
	void ScreenUV(Point2& uv, Point2 &duv)	{uv = duv = Point2(0.0, 0.0); }
	IPoint2 ScreenCoord()					{ return IPoint2(0, 0); }

	Point3 UVW(int channel)					{ return worldPos; }
	Point3 DUVW(int channel)				{ return NOT_USED_VECTOR; }
	void DPdUVW(Point3 dP[3],int channel)	{ dP[0] = dP[1] = dP[2] = NOT_USED_VECTOR; }
	Point3 UVWNormal(int channel)			{ return NOT_USED_VECTOR; }  
	void GetBGColor(Color &bgcol, Color& transp, BOOL fogBG=TRUE) { ; }

	Point3 PointTo(const Point3& p, RefFrame ito); 
	Point3 PointFrom(const Point3& p, RefFrame ifrom); 
	Point3 VectorTo(const Point3& p, RefFrame ito); 
	Point3 VectorFrom(const Point3& p, RefFrame ifrom); 
};