/*
	Description : 	Preview Render, gives you global controls to lower render settings for preview rendering only
	Version     : 	2.3
	Date		:	19.4.2008
	Author		:	Jerry Ylilammi

	Changelog	:
		2.3
			- Only works in VRay 1.5 SP1 and later
			- Fixed lights
			- Fixed VRay detection			
			- Fixed crash when pressing Delete without any presets in the list
			- You can now right-click anywhere in the dialog to open right-click menu
			- Added min samples and global subdiv multiplier overrides
			- Added dof and mb override which supports VRayPhysicalCamera and render dialog settings
			- Loading presets now requires only clicking item on the list, not double clicking
		2.2
			- Fixed problem with Crop Render
			- Added support for previous max version
		2.1
	      - Fixed problem with instanced lights that
		2.0
			- Preset manager
			- Custom presets (including irradiance map presets)
			- Show Calc Phase override
		1.2a
			- Fixed bug with resolution override
		1.2
			- Now works with Region Render
		1.1
			- Override controls for DMC
			- Resolution override works better now when render dialog is open
			- Support for VRay VFB resolution settings
*/

global berconPreviewRender
global berconPreviewRenderManager
global berconPreviewRenderPreset
global berconPreviewRenderIrrmap
global temp = undefined
try(DestroyDialog berconPreviewRender)catch()
try(DestroyDialog berconPreviewRenderManager)catch()

-- #############################################################################################
-- #################################/ Store previous settings  \################################
-- #############################################################################################

if berconPreviewRender != undefined then (
	temp = #(
		berconPreviewRender.res_o.checked,
		berconPreviewRender.res_w.value,
		berconPreviewRender.res_h.value,
		berconPreviewRender.lock.checked,
		berconPreviewRender.aa_o.checked,
		berconPreviewRender.aa_e.checked,
		berconPreviewRender.aa_q.value,
		berconPreviewRender.g_o.checked,
		berconPreviewRender.g_e.checked,
		berconPreviewRender.g_q.value,
		berconPreviewRender.rr_o.checked,
		berconPreviewRender.rr_e.checked,
		berconPreviewRender.rr_d.value,
		berconPreviewRender.s_o.checked,
		berconPreviewRender.s_e.checked,
		berconPreviewRender.s_q.value,
		berconPreviewRender.gi_o.checked,
		berconPreviewRender.gi_e.checked,
		berconPreviewRender.gi_s.checked,
		berconPreviewRender.gi_i.selection,
		berconPreviewRender.gi_b.value,
		berconPreviewRender.gi_l.value,
		berconPreviewRender.disp_o.checked,
		berconPreviewRender.disp_e.checked,
		berconPreviewRender.disp_l.value,
		berconPreviewRender.mbdof_o.checked,
		berconPreviewRender.mbdof_e.checked,
		berconPreviewRender.mbdof_q.value,
		berconPreviewRender.dmc_o.checked,
		berconPreviewRender.dmc_a.value,
		berconPreviewRender.dmc_m.value,
		berconPreviewRender.dmc_n.value,
		berconPreviewRender.dmc_g.value
	)
)


-- #############################################################################################
-- #################################/ Preset Manager           \################################
-- #############################################################################################

-- #################### // Manager dialog rollout \\ ####################
rollout berconPreviewRenderManager "Preset Manager" width:200 height:173 (
   subRollout sub width:205 height:455 pos:[0,0]
	fn resizeRollout = (
		local size = 43
		if berconPreviewRenderPreset.open then size += 126 + 4
		if berconPreviewRenderIrrmap.open then size += 273 + 4
      berconPreviewRenderManager.height = size
	)
	on berconPreviewRenderManager moved newPos do if berconPreviewRender.inDialog == true then SetDialogPos berconPreviewRender (newPos - [206,0])
	on berconPreviewRenderManager close do berconPreviewRender.presets.checked = false
)

-- #################### // Manager preset rollout \\ ####################
rollout berconPreviewRenderPreset "Preview Presets" height:100 (
	listbox presetList selection:0 height:7 pos:[0,1] width:191
	edittext presetName "Name" pos:[2,102] width:102
	button savePreset "Save" width:40 pos:[106,102] height:18
	button deletePreset "Delete" width:40 pos:[148,102] height:18

	--local ini = (getFilenamePath (getSourceFilename())) + "BerconPreviewRender.ini"
	local ini = "$scripts\BerconPreviewRender.ini" -- Switched to this since it is supported by pre 9 versions

	-- Updates preset list
	fn update = (
		local line = getINISetting ini "|List" "presets"
     	local presets = filterString line "|"
      presetList.items = presets
	)
	
	-- Load preset
	fn load = (
		berconPreviewRender.loadPreset presetList.selected
		presetName.text = presetList.selected		
	)

	on savePreset pressed do if presetName.text != "" then berconPreviewRender.savePreset presetName.text
	on deletePreset pressed do if presetList.selected != undefined then berconPreviewRender.deletePreset presetList.selected
	
	on berconPreviewRenderPreset open do update()
	on berconPreviewRenderPreset rolledUp arg do berconPreviewRenderManager.resizeRollout()
	on presetList doubleClicked val do load()
	on presetList selected val do load()
)

-- #################### // Manager irrmap rollout \\ ####################

rollout berconPreviewRenderIrrmap "Irradiance Map Presets" (
	listbox presetList selection:0 height:7 pos:[0,1] width:191
	edittext presetName "Name" pos:[2,102] width:102
	button savePre "Save" width:40 pos:[106,102] height:18
	button delPre "Delete" width:40 pos:[148,102] height:18
	spinner minRate "Min rate" type:#Integer range:[-100,100,0]
	spinner maxRate "Max rate" type:#Integer range:[-100,100,0]
	spinner hsph "HSph. subdivs" type:#Integer range:[1,1000,0]
	spinner interp "Interp. samples" type:#Integer range:[1,10000,0]
	spinner clr "Clr tresh" type:#Float range:[0.0,1000.0,0.0]
	spinner nmr "Nmr tresh" type:#Float range:[0.0,1000.0,0.0]
	spinner dist "Dist. tresh" type:#Float range:[0.0,1000.0,0.0]
	on berconPreviewRenderIrrmap rolledUp arg do berconPreviewRenderManager.resizeRollout()

	--local ini = (getFilenamePath (getSourceFilename())) + "BerconPreviewRender.ini"
	local ini = "$scripts\BerconPreviewRender.ini" -- Switched to this since it is supported by pre 9 versions

	-- Updates preset list
	fn update = (
		local line = getINISetting ini "|IrrList" "presets"
     	local presets = filterString line "|"
      presetList.items = presets
	)

-- #############################################################################################
-- #################################/ File handling - Irrmap   \################################
-- #############################################################################################

	-- Saves preset to BerconPreviewRender.ini
	fn savePreset name = (
		local val = minRate.value as String + "|" + maxRate.value as String + "|" + hsph.value as String + "|" + interp.value as String
				val += "|" + clr.value as String + "|" + nmr.value as String + "|" + dist.value as String
		berconPreviewRender.updatePresetList name irr:true
		setINISetting ini name "irrPreset" val
	)
	-- Loads preset from BerconPreviewRender.ini
	fn loadPreset name = (
      presetName.text = name
		local val = filterString (getINISetting ini name "irrPreset") "|"
		minRate.value = val[1] as Integer
		maxRate.value = val[2] as Integer
		hsph.value = val[3] as Integer
		interp.value = val[4] as Integer
		clr.value = val[5] as Float
		nmr.value = val[6] as Float
		dist.value = val[7] as Float
	)
	-- Removes preset from BerconPreviewRender.ini
	fn deletePreset name = (
		berconPreviewRender.updatePresetList name remove:true irr:true
		delIniSetting ini name "irrPreset"
	)

	on savePre pressed do if presetName.text != "" then savePreset presetName.text
	on delPre pressed do if presetList.selected != undefined then deletePreset presetList.selected
	on presetList doubleClicked val do loadPreset presetList.selected
	on presetList selected val do loadPreset presetList.selected
	on berconPreviewRenderIrrmap open do update()
)

-- #############################################################################################
-- #################################/ User Interface           \################################
-- #############################################################################################

rollout berconPreviewRender "Bercon Preview Render" width:200 height:361 (

	-- #################### // Resolution \\ ####################

	checkbutton res_o "Resolution" pos:[0,0] width:200 height:16 checked:false
	button res_1 "1:1" pos:[2,18] width:20
	button res_2 "1:2" pos:[24,18] width:20
	button res_4 "1:4" pos:[46,18] width:20
	spinner res_w "" type:#Integer range:[1,10000,640] pos:[68,21] width:54
	spinner res_h "" type:#Integer range:[1,10000,480] pos:[124,21] width:54
	checkbutton lock "L" pos:[180,18] width:18 toolTip:"Lock Aspect Ration"

	-- #################### // Anti-aliasing \\ ####################

	checkbutton aa_o "Anti-aliasing" pos:[0,41] width:200 height:16 checked:true
	checkbox aa_e "Enabled" pos:[4,61]
	spinner aa_q "Quality" type:#Integer range:[-3,100,0] pos:[138,61] width:60

   -- #################### // Glossy \\ ####################

	checkbutton g_o "Glossy" pos:[0,82] width:200 height:16 checked:true
	checkbox g_e "Enabled" pos:[4,102]
	spinner g_q "Subdivs" type:#Integer range:[1,256,1] pos:[138,102] width:60

   -- #################### // Reflection / Refraction \\ ####################

	checkbutton rr_o "Reflection / Refraction" pos:[0,123] width:200 height:16 checked:true
	checkbox rr_e "Enabled" pos:[4,143]
	spinner rr_d "Depth" type:#Integer range:[1,256,1] pos:[138,143] width:60

   -- #################### // Shadows \\ ####################

	checkbutton s_o "Shadows" pos:[0,164] width:200 height:16 checked:true
	checkbox s_e "Enabled" pos:[4,184]
	spinner s_q "Subdivs" type:#Integer range:[1,256,1] pos:[138,184] width:60

   -- #################### // Global Illumination \\ ####################

	checkbutton gi_o "Global Illumination" pos:[0,205] width:200 height:16 checked:true
	checkbox gi_e "Enabled" pos:[4,225]
	checkbox gi_s "Show Pre." pos:[4,245]
	label label1 "Irr. Map" pos:[80,229]
	dropdownlist gi_i "" pos:[119,225] width:80
	spinner gi_b "Brute Force" type:#Integer range:[1,256,0] pos:[99,249] width:99
	spinner gi_l "Light Cache" type:#Integer range:[1,10000,1] pos:[98,269] width:100

   -- #################### // Displacement \\ ####################

	checkbutton disp_o "Displacement" pos:[0,290] width:200 height:16 checked:true
	checkbox disp_e "Enabled" pos:[4,310]
	spinner disp_l "Edge Length" type:#Float range:[0.1,100.0,0.1] pos:[98,310] width:100

	-- #################### // MB and DOF \\ ####################
	
	checkbutton mbdof_o "Motion blur / Depth of field" pos:[0,331] width:200 height:16 checked:true
	checkbox mbdof_e "Enabled" pos:[4,351]
	spinner mbdof_q "Subdivs" type:#Integer range:[0,100,6] pos:[138,351] width:60	

   -- #################### // DMC \\ ####################
   
	checkbutton dmc_o "DMC" pos:[0,371] width:200 height:16 checked:true
	spinner dmc_a "Adaptive" type:#Float range:[0.0,1.0,0.85] pos:[26,391] width:70
	spinner dmc_m "Min samp." type:#Integer range:[2,100,8] pos:[128,391] width:70	
	spinner dmc_n "Noise" type:#Float range:[0.0,1.0,0.007] pos:[34,411] width:62
	spinner dmc_g "Multiplier" type:#Float range:[0.0,1000.0,1.0] pos:[128,411] width:70

   -- #################### // Render \\ ####################

	button preview "Render Preview" width:180 height:30 pos:[0,432]
	checkbutton presets "P" width:20 height:30 pos:[180,432]

-- #############################################################################################
-- #################################/ Variables                \################################
-- #############################################################################################

	local sectionPicked = 0 -- Right-clicked section
	local aspect = 1.333 -- Aspect ration
	local eMods = #() -- Array containing all edited modifiers (VRayDisplacementMod)
	local eMats = #() -- Array containing all edited materials (VRayMtl)
	local eLights = #() -- Array containing all edited lights (VRayShadow)
	local eCams = #() -- Array containing all edited cameras (VrayPhysicalCamera)
	local eModsEL = #() -- Old edge lengths for modifiers
	local eMatsSubdivs = #() -- Old subdivisions for materials
	local eLightsSubdivs = #() -- Old subdivisions for lights
	local eCamsSubdivs = #() -- Old subdivisions for cameras
	local rDialog = false -- State of render dialog
	-- Temporary storage for settings so they can be restored after render ends
	local temp_aa = undefined
	local temp_g = undefined
	local temp_rr = undefined
	local temp_s = undefined
	local temp_gi = undefined
	local temp_disp = undefined
	local temp_dmc = undefined
	local temp_mbdof = undefined
	local temp_res = undefined

-- #############################################################################################
-- #################################/ Auto resizze             \################################
-- #############################################################################################

	fn resize = (
		local offset = 0

		if res_o.checked then (
			res_1.visible = res_2.visible = res_4.visible = res_w.visible = res_h.visible = lock.visible = true
		) else (
			res_1.visible = res_2.visible = res_4.visible = res_w.visible = res_h.visible = lock.visible = false
			offset += 24
		)

		aa_o.pos = [aa_o.pos[1],41-offset]
		if aa_o.checked then (
			aa_e.visible = aa_q.visible = true
			aa_e.pos = [aa_e.pos[1],61-offset]
			aa_q.pos = [aa_q.pos[1],61-offset]
		) else (
         aa_e.visible = aa_q.visible = false
			offset += 24
		)
		
		g_o.pos = [g_o.pos[1],82-offset]
		if g_o.checked then (
			g_e.visible = g_q.visible = true
			g_e.pos = [g_e.pos[1],102-offset]
			g_q.pos = [g_q.pos[1],102-offset]
		) else (
			g_e.visible = g_q.visible = false
			offset += 24
		)

		rr_o.pos = [rr_o.pos[1],123-offset]
		if rr_o.checked then (
			rr_e.visible = rr_d.visible = true
			rr_e.pos = [rr_e.pos[1],143-offset]
			rr_d.pos = [rr_d.pos[1],143-offset]
		) else (
			rr_e.visible = rr_d.visible = false
			offset += 24
		)
		
		s_o.pos = [s_o.pos[1],164-offset]
		if s_o.checked then (
			s_e.visible = s_q.visible = true
			s_e.pos = [s_e.pos[1],184-offset]
			s_q.pos = [s_q.pos[1],184-offset]
		) else (
			s_e.visible = s_q.visible = false
			offset += 24
		)

		gi_o.pos = [gi_o.pos[1],205-offset]
		if gi_o.checked then (
			gi_e.visible = gi_s.visible = label1.visible = gi_i.visible = gi_b.visible = gi_l.visible = true
			gi_e.pos = [gi_e.pos[1],225-offset]
			gi_s.pos = [gi_s.pos[1],245-offset]
			label1.pos = [label1.pos[1],229-offset]
			gi_i.pos = [gi_i.pos[1],225-offset]
			gi_b.pos = [gi_b.pos[1],249-offset]
			gi_l.pos = [gi_l.pos[1],269-offset]
		) else (
			gi_e.visible = gi_s.visible = label1.visible = gi_i.visible = gi_b.visible = gi_l.visible = false
			offset += 68
		)

		disp_o.pos = [disp_o.pos[1],290-offset]
		if disp_o.checked then (
			disp_e.visible = disp_l.visible = true
			disp_e.pos = [disp_e.pos[1],310-offset]
			disp_l.pos = [disp_l.pos[1],310-offset]
		) else (
			disp_e.visible = disp_l.visible = false
			offset += 24
		)
		
		mbdof_o.pos = [mbdof_o.pos[1],331-offset]
		if mbdof_o.checked then (
			mbdof_e.visible = mbdof_q.visible = true
			mbdof_e.pos = [mbdof_e.pos[1],351-offset]
			mbdof_q.pos = [mbdof_q.pos[1],351-offset]
		) else (			
			mbdof_e.visible = mbdof_q.visible = false
			offset += 24
		)		
		
		dmc_o.pos = [dmc_o.pos[1],372-offset]
		if dmc_o.checked then (
			dmc_a.visible = dmc_m.visible = dmc_n.visible = dmc_g.visible = true
			dmc_a.pos = [dmc_a.pos[1],392-offset]
			dmc_m.pos = [dmc_m.pos[1],392-offset]
			dmc_n.pos = [dmc_n.pos[1],412-offset]
			dmc_g.pos = [dmc_g.pos[1],412-offset]
		) else (
			dmc_a.visible = dmc_m.visible = dmc_n.visible = dmc_g.visible = false
			offset += 41
		)

		preview.pos = [preview.pos[1],430-offset]
		presets.pos = [presets.pos[1],430-offset]

		berconPreviewRender.height = 460-offset
	)

	on res_o changed val do resize()
	on aa_o changed val do resize()
	on g_o changed val do resize()
	on rr_o changed val do resize()
	on s_o changed val do resize()
	on gi_o changed val do resize()
	on disp_o changed val do resize()
	on mbdof_o changed val do resize()
	on dmc_o changed val do resize()	

-- #############################################################################################
-- #################################/ Render Resolution         ################################
-- #############################################################################################

   fn setRes divisor = (
      if matchPattern ((classOf renderers.current) as String) pattern:"*V?Ray*" then (
			renderSceneDialog.commit()
			local vray = renderers.current

			if vray.output_getsetsfrommax then (
				res_h.value = renderHeight / divisor
				res_w.value = renderWidth / divisor
			) else (
				res_h.value = vray.output_height / divisor
				res_w.value = vray.output_width / divisor
			)
			aspect = res_w.value as Float / res_h.value as Float
		)
	)

	on res_1 pressed do setRes 1
	on res_2 pressed do setRes 2
	on res_4 pressed do setRes 4
	on res_h changed val do if lock.checked then res_w.value = val * aspect else aspect = res_w.value / val
	on res_w changed val do if lock.checked then res_h.value = val / aspect else aspect = val / res_h.value

-- #############################################################################################
-- #################################/ Presets                  \################################
-- #############################################################################################

	--local ini = (getFilenamePath (getSourceFilename())) + "BerconPreviewRender.ini"
	local ini = "$scripts\BerconPreviewRender.ini" -- Switched to this since it is supported by pre 9 versions

	-- Open manager
	on presets changed val do (
		if berconPreviewRenderManager.inDialog then ( -- Close
			try(DestroyDialog berconPreviewRenderManager)catch()
			presets.checked = false
		) else ( -- Open
			CreateDialog berconPreviewRenderManager style:#(#style_toolwindow, #style_sysmenu) pos:((GetDialogPos berconPreviewRender) + [206,0])
			addSubRollout berconPreviewRenderManager.sub berconPreviewRenderPreset
			addSubRollout berconPreviewRenderManager.sub berconPreviewRenderIrrmap rolledUp:true
			presets.checked = true
		)
	)
	
	-- Updates Irrmap dropdownlist
	fn updateList = (
		local line = getINISetting ini "|IrrList" "presets"
     	local presets = filterString line "|"
      gi_i.items = presets
	)

	-- Updates preset list
	fn updatePresetList name remove:false irr:false = ( -- remove:true removes, remove:false adds
		if irr then
			local list = "|IrrList"
		else
			local list = "|List"

		local line = getINISetting ini list "presets"
     	local presets = filterString line "|"
     	if remove then (
     		local temp = ""
			for i in presets where i != name do temp += (i + "|" )
         setINISetting ini list "presets" temp
     	) else if (findItem presets name) == 0 then (
     		setINISetting ini list "presets" (line + name + "|")
		)

		if irr then (
			berconPreviewRenderIrrmap.update()
			updateList()
		) else (
			berconPreviewRenderPreset.update()
		)
	)

	-- Saves preset to BerconPreviewRender.ini
	fn savePreset name = (
		local val = #(
			res_o.checked,
			res_w.value,
			res_h.value,
			lock.checked,
			aa_o.checked,
			aa_e.checked,
			aa_q.value,
			g_o.checked,
			g_e.checked,
			g_q.value,
			rr_o.checked,
			rr_e.checked,
			rr_d.value,
			s_o.checked,
			s_e.checked,
			s_q.value,
			gi_o.checked,
			gi_e.checked,
			gi_s.checked,
			gi_i.selected,
			gi_b.value,
			gi_l.value,
			disp_o.checked,
			disp_e.checked,
			disp_l.value,
			mbdof_o.checked,
			mbdof_e.checked,
			mbdof_q.value,
			dmc_o.checked,
			dmc_a.value,
			dmc_m.value,
			dmc_n.value,
			dmc_g.value			
		)
		local preset = ""
		for i in val do preset += (i as String) + "|" -- extra | in the end doesn't matter
		if doesFileExist ini == false then -- ensures that we have an ini file to write to
      	close (createFile ini)
		updatePresetList name
		setINISetting ini name "preset" preset
	)
	-- Loads preset from BerconPreviewRender.ini
	fn loadPreset name = (
		local val = filterString (getINISetting ini name "preset") "|"		
		if (val.count == 33) then (
			--res_o.checked = val[1] as BooleanClass
			--res_w.value = val[2] as Integer
			--res_h.value = val[3] as Integer
			--lock.checked = val[4] as BooleanClass
			aa_o.checked = val[5] as BooleanClass
			aa_e.checked = val[6] as BooleanClass
			aa_q.value = val[7] as Integer
			g_o.checked = val[8] as BooleanClass
			g_e.checked = val[9] as BooleanClass
			g_q.value = val[10] as Integer
			rr_o.checked = val[11] as BooleanClass
			rr_e.checked = val[12] as BooleanClass
			rr_d.value = val[13] as Integer
			s_o.checked = val[14] as BooleanClass
			s_e.checked = val[15] as BooleanClass
			s_q.value = val[16] as Integer
			gi_o.checked = val[17] as BooleanClass
			gi_e.checked = val[18] as BooleanClass
			gi_s.checked = val[19] as BooleanClass

			local irrMapPreset = (findItem gi_i.items val[20])
			if irrMapPreset == 0 then
				irrMapPreset = 1
			gi_i.selection = irrMapPreset

			gi_b.value = val[21] as Integer
			gi_l.value = val[22] as Integer
			disp_o.checked = val[23] as BooleanClass
			disp_e.checked = val[24] as BooleanClass
			disp_l.value = val[25] as Float
			mbdof_o.checked = val[26] as BooleanClass
			mbdof_e.checked = val[27] as BooleanClass
			mbdof_q.value  = val[28] as Float
			dmc_o.checked = val[29] as BooleanClass
			dmc_a.value = val[30] as Float
			dmc_m.value  = val[31] as Float
			dmc_n.value = val[32] as Float
			dmc_g.value = val[33] as Float						
		)
		resize()
	)
	-- Removes preset from BerconPreviewRender.ini
	fn deletePreset name = (
		updatePresetList name remove:true
		delIniSetting ini name "preset"
	)

	fn closeAll = ( res_o.checked = aa_o.checked = g_o.checked = rr_o.checked = s_o.checked = gi_o.checked = disp_o.checked = mbdof_o.checked = dmc_o.checked = false
		resize() )

	fn openAll = ( res_o.checked = aa_o.checked = g_o.checked = rr_o.checked = s_o.checked = gi_o.checked = disp_o.checked = mbdof_o.checked = dmc_o.checked = true
		resize() )

	fn openRCMenu = (
		local line = getINISetting ini "|List" "presets"
     	local presets = filterString line "|"
		local presetListing = ""
		local presetFunctions = ""

		for i in 1 to presets.count do (
			presetListing += "menuItem p" + i as String + " \"" + presets[i] + "\"\n"
			presetListing += "on p" + i as String + " picked do berconPreviewRender.loadPreset \"" + presets[i] + "\"\n"
		)

		execute ("
		RCMenu presetsMenu (
			" + presetListing + "
			separator sep1
			menuItem open \"Open All\"
			menuItem close \"Close All\"
			separator sep2
			subMenu \"Reset presets\" (
				menuItem resetPresets \"Reset\"
			)
			separator sep3
			subMenu \"About\" (
         	menuItem about1 \"Bercon Preview Render\"
         	menuItem about2 \"Version 2.3\"
         	menuItem about3 \"Copyright  Jerry Ylilammi\"
			)

			" + presetFunctions + "
			on resetPresets picked do berconPreviewRender.resetIni()
			on open picked do berconPreviewRender.openAll()
			on close picked do berconPreviewRender.closeAll()
		)
		popUpMenu presetsMenu pos:mouse.screenpos
		")
	)

	on aa_o rightclick do openRCMenu()
	on g_o rightclick do openRCMenu()
	on rr_o rightclick do openRCMenu()
	on s_o rightclick do openRCMenu()
	on gi_o rightclick do openRCMenu()
	on disp_o rightclick do openRCMenu()
	on mbdof_o rightclick do openRCMenu()
	on dmc_o rightclick do openRCMenu()	
	on preview rightclick do openRCMenu()
	on berconPreviewRender rbuttondown val do openRCMenu()	

-- #############################################################################################
-- #################################/ Node handling            \################################
-- #############################################################################################

	-- #################### // Displacement Modifiers \\ ####################
	fn editDispMods = (
		for i in objects do for j in i.modifiers where classOf j == VRayDisplacementMod and findItem eMods j == 0 do (
			append eMods j
			append eModsEL j.edgeLength
			if j.edgeLength < disp_l.value then j.edgeLength = disp_l.value
		)
	)

	fn restoreDispMods = (
		for i in 1 to eMods.count do eMods[i].edgeLength = eModsEL[i]
		eMods = #()
		eModsEL = #()
	)

	-- #################### // Materials \\ ####################
	fn getSubMaterials mat = (
		local mats = #(mat)
		for i in 1 to getNumSubMtls mat do
			join mats (getSubMaterials (getSubMtl mat i))
		return mats
	)

	fn editMaterials = (
		local allMats = #()
		for i in sceneMaterials where superClassOf i == material do
			join allMats (getSubMaterials i)
		for i in allMats where classOf i == VRayMtl and findItem eMats i == 0 do (
			append eMats i
			append eMatsSubdivs #(i.reflection_subdivs, i.refraction_subdivs)
			if i.reflection_subdivs > g_q.value then i.reflection_subdivs = g_q.value
			if i.refraction_subdivs > g_q.value then i.refraction_subdivs = g_q.value
		)
	)

	fn restoreMaterials = (
		for i in 1 to eMats.count do (
			eMats[i].reflection_subdivs = eMatsSubdivs[i][1]
			eMats[i].refraction_subdivs = eMatsSubdivs[i][2]
		)
		eMats = #()
		eMatsSubdivs = #()
	)

	-- #################### // Lights \\ ####################
	fn editLights = (
		for i in lights do
			if classOf i == VRayLight then (				
				append eLights i
				append eLightsSubdivs i.subdivs
			) else if classOf i == VraySun then (
				append eLights i
				append eLightsSubdivs i.shadow_subdivs
			) else if isproperty i "shadowgenerator" then if classOf i.shadowgenerator == VrayShadow then (
				append eLights i.shadowgenerator
				append eLightsSubdivs i.shadowgenerator.subdivs
			)
		for i in 1 to eLights.count do
			if classOf eLights[i] == VraySun then (
				if eLights[i].shadow_subdivs > s_q.value then
					eLights[i].shadow_subdivs = s_q.value
			) else (
				if (eLights[i].subdivs) > (s_q.value) then
					eLights[i].subdivs = s_q.value
			)
	)

	fn restoreLights = (
		for i in 1 to eLights.count do
			if classOf eLights[i] == VraySun then
				eLights[i].shadow_subdivs = eLightsSubdivs[i]
			else
				eLights[i].subdivs = eLightsSubdivs[i]
		eLights = #()
		eLightsSubdivs = #()
	)
	
	-- #################### // Cameras \\ ####################	
	fn editCameras = (
		for i in cameras where classof i == VRayPhysicalCamera do (
			append eCams i
			append eCamsSubdivs #(i.use_dof, i.use_moblur, i.subdivs)		
			i.use_dof = mbdof_e.checked
			i.use_moblur = mbdof_e.checked
			if i.subdivs > mbdof_q.value then i.subdivs = mbdof_q.value
		)
	)

	fn restoreCameras = (
		for i in 1 to eCams.count do (
			eCams[i].use_dof = eCamsSubdivs[i][1]
			eCams[i].use_moblur = eCamsSubdivs[i][2]
			eCams[i].subdivs = eCamsSubdivs[i][3]
		)
		eCams = #()
		eCamsSubdivs = #()
	)

-- #############################################################################################
-- #################################/ Render Preview           \################################
-- #############################################################################################

	-- Alters settings and stores previous settings
	fn editSettings = (
		local vray = renderers.current
		-- AA
		if aa_o.checked then try(			
			/*
				AA Quality
					-..0	Adaptive Subdivision, undersampling
					1		Fixed
					2..+	DMC
			*/
			temp_aa = #(
				vray.imageSampler_type,
				vray.fixedRate_subdivs,
				vray.twoLevel_baseSubdivs,
				vray.twoLevel_fineSubdivs,
				vray.adaptiveSubdivision_minRate,
				vray.adaptiveSubdivision_maxRate
			)

 			if aa_q.value == 1 or aa_e.checked == false then (
				vray.imageSampler_type = 0
				vray.fixedRate_subdivs = 1
			) else if aa_q.value < 1 then (
         	vray.imageSampler_type = 2
            vray.adaptiveSubdivision_minRate = aa_q.value
  				vray.adaptiveSubdivision_maxRate = 1
			) else (
				vray.imageSampler_type = 1
  				vray.adaptiveSubdivision_minRate = 1
  				vray.adaptiveSubdivision_maxRate = aa_q.value
			)
		)catch()
		
		-- Glossy
		if g_o.checked then try(
			temp_g = vray.options_glossyEffects
			if g_e.checked then (
				editMaterials()
			) else (
			  vray.options_glossyEffects = false
			)
		)catch()

		-- Reflection/Refraction
		if rr_o.checked then try(
			temp_rr = #(
				vray.options_reflectionRefraction,
				vray.options_limitDepth,
  				vray.options_maxDepth
  			)
  			if rr_e.checked then (
				vray.options_limitDepth = true
  				vray.options_maxDepth = rr_d.value
			) else (
         	vray.options_reflectionRefraction = false
			)
		)catch()

		-- Shadows
		if s_o.checked then try(
			temp_s = vray.options_shadows
			if s_e.checked then
				editLights()
			else
				vray.options_shadows = false
		)catch()
		
		-- Global Illumination
		if gi_o.checked then try(			
			temp_gi = #(
				vray.gi_on,
				vray.gi_irradmap_minRate,
				vray.gi_irradmap_maxRate,
				vray.gi_irradmap_subdivs,
				vray.gi_irradmap_interpSamples,
				vray.gi_irradmap_colorThreshold,
				vray.gi_irradmap_normalThreshold,
				vray.gi_irradmap_distThreshold,
				vray.dmcgi_subdivs,
				vray.lightcache_subdivs,
				vray.gi_irradmap_showCalcPhase,
				vray.lightcache_showCalcPhase
			)			
			if gi_e.checked then (
				local val = filterString (getINISetting ini gi_i.selected "irrPreset") "|"
				if val.count > 0 then (
					local s = #()
					for i in 1 to 4 do append s (val[i] as Integer)
					for i in 5 to 7 do append s (val[i] as Float)
				) else ( -- If gi preset wasn't found
					local s = #(-4, -3, 20, 20, 0.4, 0.3, 0.1)
				)				
				vray.gi_irradmap_minRate = s[1]
				vray.gi_irradmap_maxRate = s[2]
				vray.gi_irradmap_subdivs = s[3]
				vray.gi_irradmap_interpSamples = s[4]
				vray.gi_irradmap_colorThreshold = s[5]
				vray.gi_irradmap_normalThreshold = s[6]
				vray.gi_irradmap_distThreshold = s[7]
				vray.dmcgi_subdivs = gi_b.value
				vray.lightcache_subdivs = gi_l.value
				if gi_s.checked then (
					vray.gi_irradmap_showCalcPhase = true
					vray.lightcache_showCalcPhase = 1
				)
			) else (
				vray.gi_on = false
			)
		)catch()

		-- Displacement
		if disp_o.checked then try(
			temp_disp = #(
		    	vray.options_displacement,
		    	vray.displacement_edgeLength
			)
		   if disp_e.checked then (
				if vray.displacement_edgeLength < disp_l.value then vray.displacement_edgeLength = disp_l.value
				editDispMods()
		   ) else (
				vray.options_displacement = false
			)
		)catch()		
		
		-- Motion blur and Depth of field
		if mbdof_o.checked then try(			
			temp_mbdof = #(
		    	vray.dof_on,				
				vray.moblur_on,
				vray.dof_subdivs,
		    	vray.moblur_dmc_minSamples
			)
			editCameras()
			if mbdof_e.checked then (
				if vray.dof_subdivs > mbdof_q.value then vray.dof_subdivs = mbdof_q.value
				if vray.moblur_dmc_minSamples > mbdof_q.value then vray.moblur_dmc_minSamples = mbdof_q.value				
			) else (
				vray.dof_on = false
				vray.moblur_on = false				
			)
		)catch()		

		-- DMC
		if dmc_o.checked then try(
			temp_dmc = #(
		    	vray.dmc_earlyTermination_amount,
		    	vray.dmc_earlyTermination_minSamples,
				vray.dmc_earlyTermination_threshold,
				vray.dmc_subdivs_mult
			)
			vray.dmc_earlyTermination_amount = dmc_a.value
		    vray.dmc_earlyTermination_minSamples = dmc_m.value
			vray.dmc_earlyTermination_threshold = dmc_n.value
			vray.dmc_subdivs_mult = dmc_g.value
		)catch()
		
		-- Resolution
		if res_o.checked then (
			rDialog = renderSceneDialog.isOpen()
			if rDialog then renderSceneDialog.close()

			temp_res = #(
				renderHeight,
				renderWidth,
				vray.output_height,
				vray.output_width
			)

			renderHeight = res_h.value
			renderWidth = res_w.value
			vray.output_height = res_h.value
         vray.output_width = res_w.value
		)
	)

	-- Restores all stored settings
	fn restoreSettings = (
		local vray = renderers.current
		-- AA
		if aa_o.checked then try(
			vray.imageSampler_type = temp_aa[1]
			vray.fixedRate_subdivs = temp_aa[2]
			vray.twoLevel_baseSubdivs = temp_aa[3]
			vray.twoLevel_fineSubdivs = temp_aa[4]
			vray.adaptiveSubdivision_minRate = temp_aa[5]
			vray.adaptiveSubdivision_maxRate = temp_aa[6]
		)catch()
		-- Glossy
		if g_o.checked then try(
			vray.options_glossyEffects = temp_g
			restoreMaterials()
		)catch()
		-- Reflection/Refraction
		if rr_o.checked then try(
			vray.options_reflectionRefraction = temp_rr[1]
			vray.options_limitDepth = temp_rr[2]
			vray.options_maxDepth = temp_rr[3]
		)catch()
		-- Shadows
		if s_o.checked then try(
			vray.options_shadows = temp_s
			restoreLights()
		)catch()
		-- Global Illumination
		if gi_o.checked then try(
			vray.gi_on = temp_gi[1]
			vray.gi_irradmap_minRate = temp_gi[2]
			vray.gi_irradmap_maxRate = temp_gi[3]
			vray.gi_irradmap_subdivs = temp_gi[4]
			vray.gi_irradmap_interpSamples = temp_gi[5]
			vray.gi_irradmap_colorThreshold = temp_gi[6]
			vray.gi_irradmap_normalThreshold = temp_gi[7]
			vray.gi_irradmap_distThreshold = temp_gi[8]
			vray.dmcgi_subdivs = temp_gi[9]
			vray.lightcache_subdivs = temp_gi[10]
			vray.gi_irradmap_showCalcPhase = temp_gi[11]
			vray.lightcache_showCalcPhase = temp_gi[12]
		)catch()
		-- Displacement
		if disp_o.checked then try(
	    	vray.options_displacement = temp_disp[1]
	    	vray.displacement_edgeLength = temp_disp[2]
			restoreDispMods()
		)catch()
		-- Motion blur and Depth of field
		if mbdof_o.checked then try(
	    	vray.dof_on = temp_mbdof[1]
	    	vray.moblur_on = temp_mbdof[2]
			vray.dof_subdivs = temp_mbdof[3]
			vray.moblur_dmc_minSamples = temp_mbdof[4]
			restoreCameras()
		)catch()			
		-- DMC
		if dmc_o.checked then try(
		    vray.dmc_earlyTermination_amount = temp_dmc[1]
		    vray.dmc_earlyTermination_minSamples = temp_dmc[2]
			vray.dmc_earlyTermination_threshold = temp_dmc[3]
			vray.dmc_subdivs_mult = temp_dmc[4]
		)catch()
		-- Resolution
		if res_o.checked then (
			renderHeight = temp_res[1]
			renderWidth = temp_res[2]
			vray.output_height = temp_res[3]
			vray.output_width = temp_res[4]
			if rDialog then renderSceneDialog.open()
		)
	)

	fn renderPreview = if matchPattern ((classOf renderers.current) as String) pattern:"*V?Ray*" then (		
		-- #################### // Alter settings \\ ####################
		temp_aa = temp_g = temp_rr = temp_s = temp_gi = temp_disp = temp_dmc = temp_res = undefined -- Reset stored settings if any
		editSettings()

		-- #################### // Render \\ ####################
		if getrendertype() == #region or getrendertype() == #crop then try(max render last)catch()
		else try(max quick render)catch()

		-- #################### // Restore settings \\ ####################
		restoreSettings()
	)

   -- #################### // Preview Render button \\ ####################
	on preview pressed do renderPreview()

	-- #################### // Dialog movement \\ ####################
	on berconPreviewRender moved newPos do if berconPreviewRenderManager.inDialog == true then SetDialogPos berconPreviewRenderManager (newPos + [206,0])

	-- #################### // Load gi presets \\ ####################
	on berconPreviewRender open do updateList()

	-- #################### // Close preset manager \\ ####################
	on berconPreviewRender close do try(DestroyDialog berconPreviewRenderManager)catch()
	
	-- #############################################################################################
	-- #################################/ Reset ini file           \################################
	-- #############################################################################################

	fn resetIni = (
		local s = createFile ini
format "[|List]
presets=Low|Medium|High|Very High|
[|IrrList]
presets=Very Low|Low|Medium|High|Very High|
[Very Low]
irrPreset=-4|-3|20|20|0.4|0.3|0.1
[Low]
irrPreset=-3|-3|30|20|0.4|0.3|0.1
preset=false|640|480|false|true|true|-2|true|true|2|true|true|2|true|true|1|true|true|true|Very Low|4|200|true|false|14.0|true|true|2|false|0.85|8|0.015|1.0|
[Medium]
irrPreset=-3|-1|40|30|0.4|0.3|0.1
preset=false|640|480|false|true|true|1|true|true|4|true|true|5|true|true|4|true|true|true|Low|8|400|true|true|14.0|true|true|4|false|0.85|8|0.015|1.0|
[High]
irrPreset=-3|-1|50|40|0.3|0.1|0.1
preset=false|640|480|false|true|true|2|true|true|8|true|true|5|true|true|8|true|true|true|Medium|12|600|true|true|8.0|true|true|4|false|0.85|8|0.015|1.0|
[Very High]
irrPreset=-3|0|50|40|0.3|0.1|0.1
preset=false|640|480|false|true|true|4|true|true|16|false|true|5|true|true|16|true|true|true|High|16|800|false|true|8.0|false|false|6|false|0.85|8|0.015|1.0|" to:s
		close s
		
      berconPreviewRender.updateList()
      if berconPreviewRenderManager.inDialog == true then (
			berconPreviewRenderPreset.update()
			berconPreviewRenderIrrmap.update()
		)
	)
)

CreateDialog berconPreviewRender style:#(#style_toolwindow, #style_sysmenu)

-- #############################################################################################
-- #################################/ Restore previous settings\################################
-- #############################################################################################

-- First create ini file if it doesn't exist
--if doesFileExist ((getFilenamePath (getSourceFilename())) + "BerconPreviewRender.ini") == false then
if doesFileExist "$scripts\BerconPreviewRender.ini" == false then
	berconPreviewRender.resetIni()

if temp != undefined then (
	berconPreviewRender.res_o.checked = temp[1]
	berconPreviewRender.res_w.value = temp[2]
	berconPreviewRender.res_h.value = temp[3]
	berconPreviewRender.lock.checked = temp[4]
	berconPreviewRender.aa_o.checked = temp[5]
	berconPreviewRender.aa_e.checked = temp[6]
	berconPreviewRender.aa_q.value = temp[7]
	berconPreviewRender.g_o.checked = temp[8]
	berconPreviewRender.g_e.checked = temp[9]
	berconPreviewRender.g_q.value = temp[10]
	berconPreviewRender.rr_o.checked = temp[11]
	berconPreviewRender.rr_e.checked = temp[12]
	berconPreviewRender.rr_d.value = temp[13]
	berconPreviewRender.s_o.checked = temp[14]
	berconPreviewRender.s_e.checked = temp[15]
	berconPreviewRender.s_q.value = temp[16]
	berconPreviewRender.gi_o.checked = temp[17]
	berconPreviewRender.gi_e.checked = temp[18]
	berconPreviewRender.gi_s.checked = temp[19]
	berconPreviewRender.gi_i.selection = temp[20]
	berconPreviewRender.gi_b.value = temp[21]
	berconPreviewRender.gi_l.value = temp[22]
	berconPreviewRender.disp_o.checked = temp[23]
	berconPreviewRender.disp_e.checked = temp[24]
	berconPreviewRender.disp_l.value = temp[25]	
	berconPreviewRender.mbdof_o.checked = temp[26]
	berconPreviewRender.mbdof_e.checked = temp[27]
	berconPreviewRender.mbdof_q.value = temp[28]		
	berconPreviewRender.dmc_o.checked = temp[29]
	berconPreviewRender.dmc_a.value = temp[30]
	berconPreviewRender.dmc_m.value = temp[31]	
	berconPreviewRender.dmc_n.value = temp[32]
	berconPreviewRender.dmc_g.value = temp[33]	
	
	berconPreviewRender.resize()
	temp = undefined
) else (
	-- Loads first preset as default
  	berconPreviewRender.loadPreset (filterString (getINISetting berconPreviewRender.ini "|List" "presets") "|")[1]
)

/*
	Copyright  Jerry Ylilammi
*/